package com.example.tp5_07;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {
    private static final String TAG = "MainActivity";
    TextView textView;
    int i = 0;

    Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            Log.i(TAG, "handleMessage: Thead ID: " + Thread.currentThread().getId());
            Bundle bundle = msg.getData();
            String string = bundle.getString("MESSAGE_KEY");
            textView.setText(string);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Log.i(TAG, "onCreate: Thead ID: " + Thread.currentThread().getId());
        textView = (TextView) findViewById(R.id.textview);

        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(MainActivity.this, "Inner Thread", Toast.LENGTH_SHORT).show();
                new Thread() {
                    public void run() {

                        while (i++ < 100) {
                            try {
                                Log.i(TAG, "Thread:run: Thead ID: " + Thread.currentThread().getId());
                                Message message = handler.obtainMessage();
                                Bundle bundle = new Bundle();
                                bundle.putString("MESSAGE_KEY", "#" + i);
                                message.setData(bundle);
                                handler.sendMessage(message);
                                Thread.sleep(300);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }.start();
            }
        });
        Button button2 = (Button) findViewById(R.id.button2);
        button2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(MainActivity.this, "Thread Subclass (WorkerThread)", Toast.LENGTH_SHORT).show();
                WorkerThread worker = new WorkerThread(handler);
                worker.start();;
            }
        });
    }
}
